/*=========================================================
	
	dmem.c
	
	IǗB
	q[v𐔎ɌqŁÃ𓮓IɊmۂB
	ĂsI[o[wbh傫̂ŁA
	TCYĂꍇ́Aheap.hmemory.hŒڊmۂ悢B
	
	Lяk݂郊NXgȂǂŗLB
	
=========================================================*/
#include "dmem.h"

/*=========================================================
	}N
=========================================================*/
#define DMEM_DEFAULT_MINBLOCK 1024
#define DMEM_HEADER_SIZE ( HEAP_HEADER_SIZE + sizeof( struct dmem_heap ) )

/*=========================================================
	^錾
=========================================================*/
struct dmem_heap {
	HeapUID uid;
	size_t maxFreeSize;
	size_t count;
	struct dmem_heap *next;
};

struct dmem_root {
	size_t minHeapSize;
	int    allocType;
	struct dmem_heap *heapList;
	struct dmem_heap *lastUse;
};

/*=========================================================
	[J֐
=========================================================*/
static size_t dmem_need_heapsize( size_t minblock, size_t requestsize );
static struct dmem_heap *dmem_heap_new( size_t heapsize, int type );

/*=========================================================
	֐
=========================================================*/
DmemUID dmemNew( size_t minblock, int type )
{
	struct dmem_root *root;
	
	if( type != PSP_SMEM_High ) type = PSP_SMEM_Low;
	
	root = memoryAllocEx( "DmemParams", MEMORY_USER, 0, sizeof( struct dmem_root ), type, NULL );
	if( ! root ) return 0;
	
	root->minHeapSize = minblock > 0 ? minblock : DMEM_DEFAULT_MINBLOCK;
	root->allocType   = type;
	root->heapList    = NULL;
	root->lastUse     = NULL;
	
	return (DmemUID)root;
}

void *dmemAlloc( DmemUID uid, size_t size )
{
	struct dmem_root *root = (struct dmem_root *)uid;
	struct dmem_heap **ptr;
	
	if( ! root->lastUse ){
		/* ܂q[v΍ŏ̃q[v쐬 */
		root->heapList = dmem_heap_new( dmem_need_heapsize( root->minHeapSize, size ), root->allocType );
		if( ! root->heapList ) return NULL;
		root->lastUse = root->heapList;
	} else if( root->lastUse->maxFreeSize < size + DMEM_HEADER_SIZE ){
		struct dmem_heap *heap;
		
		/* \ȋ󂫗eʂ̂q[vT */
		for( heap = root->heapList; heap; heap = heap->next ){
			if( heap->maxFreeSize >= size + DMEM_HEADER_SIZE ) break;
		}
		
		/* 󂫂ΐVK쐬 */
		if( ! heap ){
			struct dmem_heap *last;
			
			heap = dmem_heap_new( dmem_need_heapsize( root->minHeapSize, size ), root->allocType );
			if( ! heap ) return NULL;
			
			for( last = root->lastUse; last->next; last = last->next );
			last->next = heap;
		}
		root->lastUse = heap;
	}
	
	/* 󂫂A邢͐VK쐬q[v烁mۂAeƂȂq[ṽ|C^Zbg */
	ptr = heapAlloc( root->lastUse->uid, size + sizeof( struct dmem_heap * ) );
	*ptr = root->lastUse;
	
	/* 蓖ăJEg𑝉 */
	root->lastUse->count++;
	
	/* q[v̋󂫗eʂXV */
	root->lastUse->maxFreeSize = heapMaxFreeSize( root->lastUse->uid );
	
	/* eƂȂq[ṽ|C^Ă镔̌̈ƂĕԂ */
	return (void *)( (uintptr_t)ptr + sizeof( struct dmem_heap * ) );
}

void *dmemCalloc( DmemUID uid, size_t nelem, size_t size )
{
	void *ptr;
	
	/* I[o[t[`FbN */
	if( ( nelem * size ) / size != nelem ) return NULL;
	
	ptr = dmemAlloc( uid, nelem * size );
	if( ptr ) memset( ptr, 0, nelem * size );
	return ptr;
}

int dmemFree( DmemUID uid, void *ptr )
{
	struct dmem_root *root = (struct dmem_root *)uid;
	struct dmem_heap **heap;
	
	if( ! ptr || ! root->lastUse ) return CG_ERROR_OK;
	
	heap = (struct dmem_heap **)( (uintptr_t)ptr - sizeof( struct dmem_heap * ) );
	
	if( (*heap)->count == 1 ){
		/* q[vubNɎȂ΃q[vƉ */
		struct dmem_heap *avail_heap;
		
		if( *heap == root->heapList ){
			/* 폜Ώۃq[v擪̏ꍇ̓[g̃q[vGAXg̊JnʒuC */
			avail_heap = (*heap)->next;
			root->heapList = avail_heap;
		} else{
			/* 폜Ώۃq[v̑Õq[v擾 */
			for( avail_heap = root->heapList; avail_heap; avail_heap = avail_heap->next ){
				if( avail_heap->next == *heap ) break;
			}
			
			if( ! avail_heap ){
				/* 폜Ώۃq[ṽAhX́AnꂽDmemUID̊ǊO */
				return CG_ERROR_INVALID_ARGUMENT;
			}
			
			/* ăN */
			avail_heap->next = (*heap)->next;
		}
		
		/*
			ŌɎgpq[v폜Ώۃq[vwĂAǂł̂ŐĂq[vwB
			󂫗eʂ𒲂ׂȂ̂́AdmemAlloc()ɌvZ邽߁B
		*/
		if( root->lastUse == *heap ) root->lastUse = avail_heap;
		
		heapDestroy( (*heap)->uid );
	} else{
		int ret;
		/* q[vɊ蓖čς݃JEgZAq[vɕԋp */
		(*heap)->count--;
		ret = heapFree( (*heap)->uid, (void *)heap );
		
		if( ret != CG_ERROR_OK ) return ret;
	}
	
	return CG_ERROR_OK;
}

void dmemDestroy( DmemUID uid )
{
	struct dmem_root *root = (struct dmem_root *)uid;
	
	if( root->heapList ){
		struct dmem_heap *prev = root->heapList;
		struct dmem_heap *cur  = prev->next;
		
		while( cur ){
			heapDestroy( prev->uid );
			prev = cur;
			cur  = cur->next;
		}
		heapDestroy( prev->uid );
	}
	
	memoryFree( root );
}

static size_t dmem_need_heapsize( size_t minblock, size_t requestsize )
{
	size_t first_data_size = requestsize + DMEM_HEADER_SIZE; //HEAP_HEADER_SIZE + sizeof( struct dmem_heap );
	
	if( first_data_size > minblock ){
		return first_data_size;
	} else{
		return minblock;
	}
}

static struct dmem_heap *dmem_heap_new( size_t heapsize, int type )
{
	struct dmem_heap *newheap;
	HeapUID huid = heapCreateEx( "DmemHeap", MEMORY_USER, 0, heapsize, type, NULL );
	if( ! huid ) return NULL;
	
	newheap              = heapAlloc( huid, sizeof( struct dmem_heap ) );
	newheap->uid         = huid;
	newheap->maxFreeSize = heapMaxFreeSize( huid );
	newheap->count       = 0;
	newheap->next        = NULL;
	
	return newheap;
}
